<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\Daily_Quiz_Leaderboard;
use App\Models\User;
use Illuminate\Http\Request;
use Exception;

class DailyQuizLeaderboardController extends Controller
{
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index(Request $request)
    {
        try {
            $params['user'] = User::latest()->get();

            if ($request->ajax()) {

                $input_user = $request['input_user'];
                $input_start_date = $request['input_start_date'];
                $input_end_date = $request['input_end_date'];

                $query = Daily_Quiz_Leaderboard::latest();
                if ($input_user != 0) {
                    $query->where('user_id', $input_user);
                }
                if (!empty($input_start_date)) {
                    $query->whereDate('created_at', '>=', date('Y-m-d', strtotime($input_start_date)));
                }
                if (!empty($input_end_date)) {
                    $query->whereDate('created_at', '<=', date('Y-m-d', strtotime($input_end_date)));
                }
                $data = $query->with('user')->latest()->get();

                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('status', function ($row) {
                        if ($row->status == 1) {
                            $showLabel = __('label.passed');
                            return "<button type='button' class='show-btn'>$showLabel</button>";
                        } else {
                            $hideLabel = __('label.failed');
                            return "<button type='button' class='hide-btn'>$hideLabel</button>";
                        }
                    })
                    ->addColumn('date', function ($row) {
                        return date("Y-m-d", strtotime($row['created_at']));
                    })
                    ->rawColumns(['status'])
                    ->make(true);
            }
            return view('admin.daily_quiz_leaderboard.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
